/**
 *
 * Ce programme montre comment il est possible de demander à l'utilisateur de 
 * cliquer sur la souris et de récuperer alors les coordonnés de la position de
 * la souris.
 *
 * Pour cela, le programme utilise la fonction :
 *
 *-----------------------------------------------------------------------------
 * MLV_mouse_wait : Suspend l'exécution du programme jusqu'à ce que 
 *                  l'utilisateur clique sur le bouton gauche de la souris.
 *                  Au moment où l'utilisateur clique, la fonction retourne les
 *                  coordonnées de la position de la souris dans la fenêtre.
 *
 * void MLV_mouse_wait(
 *     int *    x,    Coordonnée en X de la position de la souris
 *     int *    y     Coordonnée en Y de la position de la souris
 * );
 *-----------------------------------------------------------------------------
 */

#include <MLV_all.h>

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main(int argc, char *argv[]){
	//
	// Décalaration des variables qui contiendront les positions
	// de la souris.
	//
	int x,y;

	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", 640, 480 );

	//
	// Affiche la consigne
	//
	MLV_draw_text(
		10, 10,
		"Cliquez sur la fenêtre à l'aide de la souris pour faire apparaître un cercle",
		MLV_COLOR_GREEN
	);
	MLV_actualise_window();

	//
	// Attendre que l'utilisateur clique sur le bouton gauche de la souris
	//
	MLV_mouse_wait(&x, &y);

	//
	// Dessine un cercle à la position du curseur de la souris
	//
	MLV_draw_circle( x, y, 30, MLV_COLOR_RED );
	MLV_actualise_window();
	
	//
	// Attend 1 seconde avant la fin du programme.
	//
	MLV_wait_seconds( 1 );
	
	//
	// Fermer la fenêtre
	//
	MLV_close_window();
	return 0;
}
