/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_keyboard.h"

#ifndef MEMORY_DEBUG
#include <SDL/SDL.h>
#else
#include "memory_debug.h"
#endif

#include "warning_error.h"

#include "memory_management.h"

void MLV_keyboard_wait( int* sym, int* mod, int* unicode ){
	SDL_Event event;
	while( SDL_PollEvent(&event) || (event.type != 	SDL_KEYDOWN) );

	if( sym ){
		(*sym) = event.key.keysym.sym;
	}
	if( mod ){
		(*mod) = event.key.keysym.mod;
	}
	if( unicode ){
		(*unicode) = event.key.keysym.unicode;
	}
}
