/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "MLV_prompt.h"
#include "MLV_figures.h"
#include "MLV_color.h"
#include "MLV_window.h"
#include "MLV_evenement.h"
#include "data_structure.h"

#include <stdlib.h>

#include "memory_management.h"

extern DataMLV* MLV_data;

void MLV_wait_particular_prompt( MLV_Prompt* prompt, char** text){
	MLV_Prompt* tmp_prompt = NULL;
	(*text) = NULL;
	while( ! (*text) ){
		MLV_Event event_type = MLV_get_event( 
			NULL, NULL,
			text, &tmp_prompt, 
			NULL, NULL, NULL,
			NULL
		);
		if( (event_type==MLV_PROMPT )  && prompt != tmp_prompt ){
			MLV_FREE( (*text), char );
			(*text) = NULL;
		}
		MLV_draw_all_prompt();
		MLV_actualise_window();
	}
}

void MLV_prompt_wait(
	int sommetHautGaucheX, int sommetHautGaucheY,
	int sommetBasDroitX, int sommetBasDroitY,
	Uint32 borderColor, Uint32 textColor,
	Uint32 backgroundColor,
	const char* informativeMessage,
	char** text
){
	MLV_Prompt* prompt = MLV_create_prompt(
		sommetHautGaucheX, sommetHautGaucheY,
		sommetBasDroitX, sommetBasDroitY,
		borderColor, textColor,
		backgroundColor,
		informativeMessage
	);

	SDL_Surface *save_screen = SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA, MLV_data->width, MLV_data->height, 32, 0, 0, 0, 0);
	SDL_BlitSurface( MLV_data->screen, NULL, save_screen, &(MLV_data->rectangle));

	MLV_wait_particular_prompt( prompt, text);
	MLV_close_prompt(prompt);

	SDL_BlitSurface( save_screen, NULL, MLV_data->screen, &(MLV_data->rectangle));
	SDL_FreeSurface( save_screen );

	MLV_actualise_window();
}

