/**
 *
 * Ce programme créé une fenêtre et affiche Bonjour.
 *
 * Pour cela le programme  utilise les fonctions suivantes : 
 *
 *------------------------------------------------------------------------------
 * MLV_create_window: Créé une fenêtre dont la taille, et les differents noms 
 *                    sont passes en parametres.
 *                    Un programme donné ne peut pas ouvrir plus d'une fenêtre à
 *                    la fois.
 *
 * void MLV_create_window(
 *    const char*     display_name,   Nom de la fenêtre
 *    const char*     icone_name,     Nom de l'icone associé a la fenêtre
 *    int             width,          Largeur de la fenêtre
 *    int             height          Hauteur de la fenêtre
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_close_window : Ferme la fenêtre courante.
 *
 * void MLV_close_window();
 *
 *------------------------------------------------------------------------------
 * MLV_actualise_window : Met a jour l'affichage de la fenêtre courante.
 *
 * void MLV_actualise_window();
 *
 *------------------------------------------------------------------------------
 *
 *
 * Le programme affiche du texte a l'aide de la fonction suivante :
 * 
 *------------------------------------------------------------------------------
 * MLV_draw_text : Imprime un texte donne a une position et une couleur donnees.
 *
 * void MLV_draw_text(
 *    int             x,       Coordonnee en X du coin Nord-Ouest du texte
 *    int             y,       Coordonnee en Y du coin Nord-Ouest du texte
 *    const char *    text,    texte a afficher
 *    MLV_Color       color    couleur du trace
 * );
 *
 *------------------------------------------------------------------------------
 *
 * Il existe d'autres fonctions pour afficher texte. Vous les trouverez en 
 * consultant le fichier MLV_text.h ou en tapant dans un terminal la commande :
 *
 * man MLV_text.h
 *
 *
 * Le programme peut aussi attendre un certain nombre de secondes en utilisant
 * la fonction :
 *
 *------------------------------------------------------------------------------
 * MLV_waits_seconds : Le programme s'interrompt pendant un nombre de secondes
 *                     donné en paramètre.
 *
 * void MLV_wait_seconds(
 *    int    seconds    Le nombre de secondes à attendre.
 * );
 *
 *------------------------------------------------------------------------------
 */

#include <MLV/MLV_all.h>
#include <stdio.h>

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[] ){

	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", 640, 480 );

	//
	// Affiche "Bonjour !" a l'écran 
	//
	MLV_draw_text(
		10, 120, 
		"Bonjour !",
		MLV_COLOR_MAGENTA
	);

	//
	// Met a jour l'affichage.
	//
	MLV_actualise_window();

	//
	// Attend 10 secondes avant la fin du programme.
	//
	MLV_wait_seconds( 10 );

	//
	// Ferme la fenêtre
	//
	MLV_close_window();

	return 0;
}
