#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <MLV/MLV_all.h>

void draw_sentence( int width, int height ){
	MLV_draw_filled_rectangle( 0, 0, width, height, MLV_COLOR_BLACK );
	MLV_draw_adapted_text_box(
		10, 50, 
		"Appuyez sur une touche pour connaître :\n    - son code,\n    - son mode,\n    - son code unicode,\n    - le caractère qui lui est associé.",
		3,
		MLV_COLOR_BLACK, MLV_COLOR_GREEN, MLV_COLOR_BLACK,
		MLV_TEXT_LEFT
	);
}

//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[] ){

	int width = 640;
	int height = 480;

	MLV_create_window( "beginner - 10 - Le code des touches du clavier", "codes - touches du clavier", width, height );

	draw_sentence( width, height );
	MLV_actualise_window();

	MLV_Keyboard_button sym;
	const char* sym_string;
	MLV_Keyboard_modifier mod;
	char* mod_string;
	int unicode;
	char unicode_string[256];
	char* character;
	char* final_text;
	int text_size;

	while( 1 ){
		MLV_wait_keyboard( &sym, &mod, &unicode );
		sym_string = MLV_convert_keyboard_button_to_string( sym );
		mod_string = MLV_convert_keyboard_mod_to_string( mod );
		character = MLV_convert_unicode_to_string( unicode );

		const char* text = "Information sur la touche:\n-------------------------\nSym : %s \nMod : %s \nUnicode : %s \nCaractère : %s \n\n";
	
		snprintf( unicode_string, 256, "%d", unicode);
		text_size = strlen( text ) + 
			strlen( sym_string ) + 
			strlen( mod_string ) +
			strlen( unicode_string ) + 
			strlen( character );
		final_text = (char*) malloc( (1+text_size)*sizeof(char) );
		sprintf( final_text, text, sym_string, mod_string, unicode_string, character );

		printf( "%s", final_text );

		draw_sentence( width, height );
		MLV_draw_adapted_text_box(
			10, 160, final_text, 6,
			MLV_COLOR_BLACK, MLV_COLOR_GREEN, MLV_COLOR_BLACK,
			MLV_TEXT_LEFT
		);
		MLV_actualise_window();

		free( character );
		free( mod_string );
		free( final_text );
	
	}

	MLV_free_window();

	return 0;
}
